export default (function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){return {data:{qtFjnNKT8c:[{id:6,date:k,date_gmt:k,guid:{rendered:"https:\u002F\u002Fapi.aiarnob.com\u002F?p=6"},modified:l,modified_gmt:l,slug:"nuxt-js-data-fetching-hook-async-data",status:"publish",type:"post",link:"https:\u002F\u002Fapi.aiarnob.com\u002Fnuxt-js-data-fetching-hook-async-data\u002F",title:{rendered:"Nuxt.js Data Fetching Hook: Async Data."},content:{rendered:"\n\u003Cp\u003EIn this blog, I am discussing the Nuxt.js asyncData hook. For server-side rendering in Nuxt.js need to use specific hooks. This allows your page to render with all of its required data presents.\u003C\u002Fp\u003E\n\n\n\n\u003Ch2 class=\"wp-block-heading\"\u003ENuxt.js has two hooks for asynchronous data loading:\u003C\u002Fh2\u003E\n\n\n\n\u003Col\u003E\n\u003Cli\u003EThe fetch hook\u003C\u002Fli\u003E\n\n\n\n\u003Cli\u003EThe asyncData hook\u003C\u002Fli\u003E\n\u003C\u002Fol\u003E\n\n\n\n\u003Cp\u003EAlso, Nuxt.js supports traditional Vue patterns for loading data in your client-side app, such as fetching data in a component&#8217;s&nbsp;\u003Cstrong\u003Emounted()\u003C\u002Fstrong\u003E&nbsp;hook.\u003C\u002Fp\u003E\n\n\n\n\u003Ch2 class=\"wp-block-heading\"\u003ESome important features of asyncData hook in Nuxt.js:\u003C\u002Fh2\u003E\n\n\n\n\u003Col\u003E\n\u003Cli\u003EasyncData works on both server-side &amp; client-side rendering.\u003C\u002Fli\u003E\n\n\n\n\u003Cli\u003EasyncData is called every time before loading a component.\u003C\u002Fli\u003E\n\n\n\n\u003Cli\u003EYou can use only on next pages, not in vue components.\u003C\u002Fli\u003E\n\n\n\n\u003Cli\u003EanyncData is called from the server-side before the component is mounted. That’s why you don’t have access to&nbsp;\u003Cstrong\u003E’this’\u003C\u002Fstrong\u003E&nbsp;keyword inside&nbsp;\u003Cstrong\u003EasyncData()\u003C\u002Fstrong\u003E.\u003C\u002Fli\u003E\n\n\n\n\u003Cli\u003EThis method receives the&nbsp;\u003Ca href=\"https:\u002F\u002Fnuxtjs.org\u002Fdocs\u002F2.x\u002Fconcepts\u002Fcontext-helpers\"\u003Econtext\u003C\u002Fa\u003E&nbsp;object as the first argument and you can use it to access core nuxt properties such as route, store, params, app, etc.\u003C\u002Fli\u003E\n\n\n\n\u003Cli\u003EThe result from asyncData will be merged with data.\u003C\u002Fli\u003E\n\u003C\u002Fol\u003E\n\n\n\n\u003Cp\u003E\u003Cstrong\u003EHere is the example of nuxt asyncData using \u003Ca href=\"https:\u002F\u002Faxios.nuxtjs.org\u002F\"\u003E@nuxt\u002Faxios\u003C\u002Fa\u003E library:\u003C\u002Fstrong\u003E\u003C\u002Fp\u003E\n\n\n\n\u003Cpre class=\"wp-block-code\"\u003E\u003Ccode\u003E&lt;template\u003E\n  &lt;div\u003E\n    &lt;h1\u003E{{ post.title }}&lt;\u002Fh1\u003E\n    &lt;p\u003E{{ post.description }}&lt;\u002Fp\u003E\n  &lt;\u002Fdiv\u003E\n&lt;\u002Ftemplate\u003E\n\n&lt;script\u003E\n  export default {\n    async asyncData({params, $axios }) {\n      const post = await $http.$get(`https:\u002F\u002Fapi.nuxtjs.dev\u002Fposts\u002F${params.id}`)\n      return { post }\n    }\n  }\n&lt;\u002Fscript\u003E\u003C\u002Fcode\u003E\u003C\u002Fpre\u003E\n\n\n\n\u003Cp\u003EasyncData hook returned the promise and resolved during the route transition. This means that no &#8220;loading placeholder&#8221; is visible during client-side transitions but you can use the&nbsp;\u003Ca href=\"https:\u002F\u002Fdev.to\u002Faiarnob\u002Fhow-to-use-nuxt-js-loading-progress-bar-39l3\"\u003Eloading bar\u003C\u002Fa\u003E&nbsp;can be used to indicate a loading state to the user.\u003C\u002Fp\u003E\n\n\n\n\u003Ch2 class=\"wp-block-heading\"\u003E\u003Ca href=\"https:\u002F\u002Fdev.to\u002Faiarnob\u002Fnuxt-js-data-fetching-hook-async-data-o9p#asyncdata-on-both-clientside-amp-serverside\"\u003E\u003C\u002Fa\u003EasyncData() on both client-side &amp; server-side:\u003C\u002Fh2\u003E\n\n\n\n\u003Cp\u003ETo test how asyncData() works on both client-side &amp; server-side, please write the bellow code on your Nuxt.js page.\u003C\u002Fp\u003E\n\n\n\n\u003Cpre class=\"wp-block-code\"\u003E\u003Ccode\u003E&lt;script\u003E\nexport default{\n    asyncData(context){\n       console.log(context);\n    }\n}\n&lt;\u002Fscript\u003E\u003C\u002Fcode\u003E\u003C\u002Fpre\u003E\n\n\n\n\u003Cp\u003E\u003Cstrong\u003EServer Side Test\u003C\u002Fstrong\u003E\u003Cbr\u003ENow reload the page on the browser and look inside your terminal(also can check on browser console panel Nuxt SSR Response) on which your Nuxt.js application running. You can see the context object like the below screenshot. That means its works on the server-side.\u003C\u002Fp\u003E\n\n\n\n\u003Cfigure class=\"wp-block-image size-full\"\u003E\u003Cimg decoding=\"async\" loading=\"lazy\" width=\"880\" height=\"735\" src=\"http:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Fwzjzudyqv04q4wdcdck1.png\" alt=\"\" class=\"wp-image-11\" srcset=\"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Fwzjzudyqv04q4wdcdck1.png 880w, https:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Fwzjzudyqv04q4wdcdck1-300x251.png 300w, https:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Fwzjzudyqv04q4wdcdck1-768x641.png 768w\" sizes=\"(max-width: 880px) 100vw, 880px\" \u002F\u003E\u003C\u002Ffigure\u003E\n\n\n\n\u003Cp\u003E\u003Cstrong\u003EClient Side Test\u003C\u002Fstrong\u003E\u003Cbr\u003EYou can also check client-side rendering when you come to this page from another Nuxt.js page (The link must be used NuxtLink for linking between pages). Now open your browser dev tools and check the console panel and you see the magic of asyncData().\u003C\u002Fp\u003E\n\n\n\n\u003Cfigure class=\"wp-block-image size-full\"\u003E\u003Cimg decoding=\"async\" loading=\"lazy\" width=\"880\" height=\"273\" src=\"http:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Foe6rcmn858p4sej707em.png\" alt=\"\" class=\"wp-image-12\" srcset=\"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Foe6rcmn858p4sej707em.png 880w, https:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Foe6rcmn858p4sej707em-300x93.png 300w, https:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Foe6rcmn858p4sej707em-768x238.png 768w\" sizes=\"(max-width: 880px) 100vw, 880px\" \u002F\u003E\u003C\u002Ffigure\u003E\n\n\n\n\u003Ch2 class=\"wp-block-heading\"\u003EHow you can use Async data in components:\u003C\u002Fh2\u003E\n\n\n\n\u003Cp\u003EWe already know that we can not use anyncData hook inside any component but we can use another way for component.\u003Cbr\u003EMake the API call in the asyncData method of the page component and pass the data as props to the sub components. Both Client &amp; Server side rendering will work fine.\u003C\u002Fp\u003E\n\n\n\n\u003Cp\u003E\u003Cstrong\u003EReferance:\u003C\u002Fstrong\u003E&nbsp;Nuxt.js Official Data Fetch&nbsp;\u003Ca href=\"https:\u002F\u002Fnuxtjs.org\u002Fdocs\u002F2.x\u002Ffeatures\u002Fdata-fetching\"\u003EHook\u003C\u002Fa\u003E\u003C\u002Fp\u003E\n",protected:i},excerpt:{rendered:"\u003Cp\u003EIn this blog, I am discussing the Nuxt.js asyncData hook. For server-side rendering in Nuxt.js need to use specific hooks. This allows your page to render with all of its required data presents. Nuxt.js has two hooks for asynchronous data loading: Also, Nuxt.js supports traditional Vue patterns for loading data in your client-side app, such [&hellip;]\u003C\u002Fp\u003E\n",protected:i},author:b,featured_media:16,comment_status:m,ping_status:m,sticky:i,template:c,format:"standard",meta:[],categories:[f,g,e],tags:[],post_img_thumbnail_large:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Fblog-3-1024x728.jpg",post_image_original:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-content\u002Fuploads\u002F2022\u002F11\u002Fblog-3.jpg",post_date_formated:"Sep 12, 2021",reading_time:"2 Minutes, 22 Seconds",post_categories:[{term_id:f,name:n,slug:o,term_group:a,term_taxonomy_id:f,taxonomy:h,description:c,parent:a,count:b,filter:j,cat_ID:f,category_count:b,category_description:c,cat_name:n,category_nicename:o,category_parent:a},{term_id:g,name:p,slug:q,term_group:a,term_taxonomy_id:g,taxonomy:h,description:c,parent:a,count:b,filter:j,cat_ID:g,category_count:b,category_description:c,cat_name:p,category_nicename:q,category_parent:a},{term_id:e,name:r,slug:s,term_group:a,term_taxonomy_id:e,taxonomy:h,description:c,parent:a,count:b,filter:j,cat_ID:e,category_count:b,category_description:c,cat_name:r,category_nicename:s,category_parent:a}],_links:{self:[{href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fposts\u002F6"}],collection:[{href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fposts"}],about:[{href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Ftypes\u002Fpost"}],author:[{embeddable:d,href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fusers\u002F1"}],replies:[{embeddable:d,href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fcomments?post=6"}],"version-history":[{count:e,href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fposts\u002F6\u002Frevisions"}],"predecessor-version":[{id:13,href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fposts\u002F6\u002Frevisions\u002F13"}],"wp:featuredmedia":[{embeddable:d,href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fmedia\u002F16"}],"wp:attachment":[{href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fmedia?parent=6"}],"wp:term":[{taxonomy:h,embeddable:d,href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Fcategories?post=6"},{taxonomy:"post_tag",embeddable:d,href:"https:\u002F\u002Fapi.aiarnob.com\u002Fwp-json\u002Fwp\u002Fv2\u002Ftags?post=6"}],curies:[{name:"wp",href:"https:\u002F\u002Fapi.w.org\u002F{rel}",templated:d}]}}]},prerenderedAt:1682368116968}}(0,1,"",true,4,3,5,"category",false,"raw","2021-09-12T14:56:24","2022-12-10T19:04:19","open","JavaScript","javascript","Nuxt.js","nuxt-js","Vue.js","vue-js"))